/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface Tooltip {
    public static final Splitter LINE_SPLITTER = Splitter.onPattern((String)"\r?\n|\\\\n");

    public List<Component> getLines();

    default public void appendNarrations(NarrationElementOutput narrationMsg) {
        this.getLines().forEach(line -> narrationMsg.m_169146_(NarratedElementType.HINT, line));
    }

    default public CharSequence getString() {
        StringBuilder builder = new StringBuilder();
        this.getLines().forEach(line -> {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(line.getString());
        });
        return builder;
    }

    default public Stream<Component> stream() {
        return this.getLines().stream();
    }

    public static Tooltip of(List<Component> lines) {
        List flines = lines.stream().map(Tooltip::of).flatMap(Tooltip::stream).collect(Collectors.toList());
        return () -> flines;
    }

    public static Tooltip of(List<FormattedText> lines, Style style) {
        List flines = lines.stream().map(line -> Tooltip.of(line, style)).flatMap(Tooltip::stream).collect(Collectors.toList());
        return () -> flines;
    }

    public static Tooltip of(String text) {
        return Tooltip.of((Component)Component.m_237115_((String)text));
    }

    public static Tooltip of(Component text) {
        return Tooltip.of((FormattedText)text, text.m_7383_());
    }

    public static Tooltip of(FormattedText text, Style styl) {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.m_237119_());
        text.m_7451_((style, part) -> {
            List parts = LINE_SPLITTER.splitToList((CharSequence)part).stream().map(i -> Component.m_237113_((String)i).m_130948_(style)).collect(Collectors.toList());
            lines.add(((MutableComponent)lines.remove(lines.size() - 1)).m_7220_((Component)parts.remove(0)));
            lines.addAll(parts);
            return Optional.empty();
        }, styl);
        return () -> lines;
    }

    public static Tooltip of(String text, int maxWidth) {
        return Tooltip.of((Component)Component.m_237115_((String)text), maxWidth);
    }

    public static Tooltip of(Component text, int maxWidth) {
        return Tooltip.of((FormattedText)text, text.m_7383_(), maxWidth);
    }

    public static Tooltip of(FormattedText text, Style style, int maxWidth) {
        return Tooltip.of(Minecraft.m_91087_().f_91062_.m_92865_().m_92414_(text, maxWidth, style), style);
    }
}

